/* Try to open mxctl and do an endpointless ioctl on it. */

#include <stdio.h>
#include <stdlib.h>

#include "myriexpress.h"
#include "mx__driver_interface.h"
#include "mx__fops.h"
#include "test_common.h"

int main(void)
{
  mx_return_t ret;
  mx_endpt_handle_t handle;
  int i;
  uint32_t x = 0;

  mx_init();
  ret = mx_open_ctl(0, &handle);
  if (ret != MX_SUCCESS) {
    printf("mx_open_ctl failed\n");
    FAIL();
  }
  printf("handle = %d\n", handle);
  i = mx__get_instance_count(handle, &x);
  if (i != 0) {
    printf("mx__get_instance_count failed\n");
    FAIL();
  }
  printf("x = %u\n", x);
  mx__close(handle);
  mx_finalize();
  PASS();
  return 0;
}
